//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net;
using System.Text;
using System.IO;
using System.Collections.Specialized;

public class SimpleHTTP
{
	public static void Main(string[] args) 
	{
		try
		{
			string address = "http://localhost/QuickStart/HowTo/";
			if(args.Length == 1)
				address = args[0];

			// WebRequest request = WebRequest.Create(address);
			// WebResponse response = request.GetResponse();
			// StreamReader reader = new StreamReader(response.GetResponseStream(), Encoding.ASCII);
			// Console.WriteLine(reader.ReadToEnd());
			// response.Close();

			WebClient wc = new WebClient();

			// wc.DownloadFile(address, "default.aspx");
			Stream stream = wc.OpenRead(address);

			// Teraz odczyt do bufora bajtw.
			byte[] bytes = new byte[1000];
			int numBytesToRead = (int) bytes.Length;
			int numBytesRead = 0;
			while ((numBytesRead = stream.Read(bytes, 0, numBytesToRead)) >= 0) 
			{
				// Odczyt moe zwrci od 0 do numBytesToRead bajtw.
				// Osignito EOF
				if (numBytesRead == 0)
					break;
				Console.WriteLine(Encoding.ASCII.GetString(bytes, 0, numBytesRead));
			}
			
			stream.Close();

			NameValueCollection query = wc.QueryString;
			int values = query.Count;

			// byte[] buffer = wc.DownloadData(address);
			// Console.WriteLine(Encoding.ASCII.GetString(buffer));

		}
		catch(Exception ex)
		{
			Console.WriteLine(ex.ToString());
		}		
	}
}
